/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.ui;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.ClientFontHelper;
import com.zurrtum.create.client.foundation.sound.SoundScapes;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.enums.PonderConfig;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import com.zurrtum.create.client.ponder.foundation.PonderChapter;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderStoryBoardEntry;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import com.zurrtum.create.client.ponder.foundation.content.DebugScenes;
import com.zurrtum.create.client.ponder.foundation.element.TextWindowElement;
import com.zurrtum.create.client.ponder.foundation.render.SceneRenderState;
import com.zurrtum.create.client.ponder.foundation.render.TitleTextRenderState;
import com.zurrtum.create.client.ponder.foundation.ui.AbstractPonderScreen;
import com.zurrtum.create.client.ponder.foundation.ui.PonderButton;
import com.zurrtum.create.client.ponder.foundation.ui.PonderProgressBar;
import com.zurrtum.create.client.ponder.foundation.ui.PonderTagScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_11256;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3674;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class PonderUI
extends AbstractPonderScreen {
    public static int ponderTicks;
    public static float ponderPartialTicksPaused;
    public static final Color BACKGROUND_TRANSPARENT;
    public static final Color BACKGROUND_FLAT;
    public static final Color BACKGROUND_IMPORTANT;
    public static final Couple<Color> COLOR_IDLE;
    public static final Couple<Color> COLOR_HOVER;
    public static final Couple<Color> COLOR_HIGHLIGHT;
    public static final Couple<Color> MISSING_VANILLA_ENTRY;
    public static final Couple<Color> MISSING_MODDED_ENTRY;
    private final SoundScapes soundScapes;
    private final List<PonderScene> scenes;
    private final List<PonderTag> tags;
    private List<PonderButton> tagButtons = new ArrayList<PonderButton>();
    private List<LerpedFloat> tagFades = new ArrayList<LerpedFloat>();
    private final LerpedFloat fadeIn;
    class_1799 stack;
    GuiGameElement.GuiItemRenderBuilder itemRender;
    @Nullable
    PonderChapter chapter = null;
    private boolean userViewMode;
    private boolean identifyMode;
    private class_1799 hoveredTooltipItem = class_1799.field_8037;
    @Nullable
    private class_2338 hoveredBlockPos;
    private final class_3674 clipboardHelper;
    @Nullable
    private class_2338 copiedBlockPos;
    private final LerpedFloat finishingFlash;
    private final LerpedFloat nextUp;
    private int finishingFlashWarmup = 0;
    private int nextUpWarmup = 0;
    private final LerpedFloat lazyIndex;
    private int index = 0;
    @Nullable
    private PonderTag referredToByTag;
    private PonderButton left;
    private PonderButton right;
    private PonderButton scan;
    private PonderButton chap;
    private PonderButton userMode;
    private PonderButton close;
    private PonderButton replay;
    private PonderButton slowMode;
    private int skipCooling = 0;
    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(class_2960 id) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(id));
    }

    public static PonderUI of(class_1799 item) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(RegisteredObjectsHelper.getKeyOrThrow(item.method_7909())));
    }

    public static PonderUI of(class_1799 item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderIndex.getSceneAccess().compile(RegisteredObjectsHelper.getKeyOrThrow(item.method_7909())));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    protected PonderUI(List<PonderScene> scenes) {
        List<PonderScene> orderedScenes;
        this.soundScapes = new SoundScapes(true);
        class_2960 location = scenes.get(0).getLocation();
        this.stack = new class_1799(RegisteredObjectsHelper.getItemOrBlock(location));
        this.itemRender = (GuiGameElement.GuiItemRenderBuilder)((GuiGameElement.GuiItemRenderBuilder)GuiGameElement.of(this.stack).scale(2.0f)).at(-35.0f, 1.0f);
        this.tags = new ArrayList<PonderTag>(PonderIndex.getTagAccess().getTags(location));
        Ponder.LOGGER.debug("Ponder Scenes before ordering: {}", (Object)Arrays.toString(scenes.stream().map(PonderScene::getId).toArray()));
        try {
            orderedScenes = this.orderScenes(scenes);
            Ponder.LOGGER.debug("Ponder Scenes after ordering: {}", (Object)Arrays.toString(orderedScenes.stream().map(PonderScene::getId).toArray()));
        }
        catch (Exception e) {
            Ponder.LOGGER.warn("Unable to sort PonderScenes, using unordered List", (Throwable)e);
            orderedScenes = scenes;
        }
        this.scenes = orderedScenes;
        if (this.scenes.isEmpty()) {
            List<StoryBoardEntry> list = Collections.singletonList(new PonderStoryBoardEntry(DebugScenes::empty, "ponder", "debug/scene_1", class_2960.method_60654((String)"stick")));
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(list));
        }
        this.lazyIndex = LerpedFloat.linear().startWithValue(this.index);
        this.fadeIn = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.clipboardHelper = new class_3674();
        this.finishingFlash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.nextUp = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.4f, LerpedFloat.Chaser.EXP);
    }

    private List<PonderScene> orderScenes(List<PonderScene> scenes) {
        Map<Boolean, List<PonderScene>> partitioned = scenes.stream().collect(Collectors.partitioningBy(scene -> scene.getOrderingEntries().isEmpty()));
        List<PonderScene> scenesWithOrdering = partitioned.get(false);
        List<PonderScene> scenesWithoutOrdering = partitioned.get(true);
        if (scenesWithOrdering.isEmpty()) {
            return scenes;
        }
        ArrayList<PonderScene> sceneList = new ArrayList<PonderScene>(scenes);
        Collections.reverse(sceneList);
        Map<class_2960, PonderScene> sceneLookup = scenes.stream().collect(Collectors.toMap(PonderScene::getId, scene -> scene));
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        sceneList.forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        IntStream.range(1, scenesWithoutOrdering.size()).forEach(i -> graph.putEdge((Object)((PonderScene)scenesWithoutOrdering.get(i - 1)), (Object)((PonderScene)scenesWithoutOrdering.get(i))));
        scenesWithOrdering.forEach(scene -> {
            List<StoryBoardEntry.SceneOrderingEntry> relevantOrderings = scene.getOrderingEntries().stream().filter(entry -> scenes.stream().anyMatch(sc -> sc.getId().equals((Object)entry.sceneId()))).toList();
            if (relevantOrderings.isEmpty()) {
                return;
            }
            relevantOrderings.forEach(entry -> {
                PonderScene otherScene = (PonderScene)sceneLookup.get(entry.sceneId());
                if (entry.type() == StoryBoardEntry.SceneOrderingType.BEFORE) {
                    graph.putEdge(scene, (Object)otherScene);
                } else if (entry.type() == StoryBoardEntry.SceneOrderingType.AFTER) {
                    graph.putEdge((Object)otherScene, scene);
                }
            });
        });
        return PonderUI.topologicalSort((MutableGraph<PonderScene>)graph);
    }

    private static List<PonderScene> topologicalSort(MutableGraph<PonderScene> graph) {
        ArrayList<PonderScene> result = new ArrayList<PonderScene>();
        HashSet<PonderScene> visited = new HashSet<PonderScene>();
        HashSet<PonderScene> currentlyVisiting = new HashSet<PonderScene>();
        for (PonderScene node : graph.nodes()) {
            if (visited.contains(node) || PonderUI.dfs(node, graph, visited, currentlyVisiting, result)) continue;
            throw new IllegalArgumentException("Graph has a cycle!");
        }
        Collections.reverse(result);
        return result;
    }

    private static boolean dfs(PonderScene node, MutableGraph<PonderScene> graph, Set<PonderScene> visited, Set<PonderScene> currentlyVisiting, List<PonderScene> result) {
        if (currentlyVisiting.contains(node)) {
            return false;
        }
        if (!visited.contains(node)) {
            currentlyVisiting.add(node);
            for (PonderScene neighbor : graph.successors((Object)node)) {
                if (PonderUI.dfs(neighbor, graph, visited, currentlyVisiting, result)) continue;
                return false;
            }
            currentlyVisiting.remove(node);
            visited.add(node);
            result.add(node);
        }
        return true;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        SoundScapes.setInstance(this.soundScapes);
        this.tagButtons = new ArrayList<PonderButton>();
        this.tagFades = new ArrayList<LerpedFloat>();
        this.tags.forEach(t -> {
            int i = this.tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;
            PonderButton b2 = (PonderButton)((AbstractSimiWidget)new PonderButton(x, y).showing((ScreenElement)t)).withCallback((mX, mY) -> {
                this.centerScalingOn((int)mX, (int)mY);
                ScreenOpener.transitionTo(new PonderTagScreen((PonderTag)t));
            });
            this.method_37063(b2);
            this.tagButtons.add(b2);
            LerpedFloat chase = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.05f, LerpedFloat.Chaser.exp(0.1));
            this.tagFades.add(chase);
        });
        class_315 bindings = this.field_22787.field_1690;
        int spacing = 8;
        int bX = (this.field_22789 - 20) / 2 - (70 + 2 * spacing);
        int bY = this.field_22790 - 20 - 31;
        int pX = this.field_22789 / 2 - 110;
        int pY = bY + 20 + 4;
        int pW = this.field_22789 - 2 * pX;
        this.method_37063(new PonderProgressBar(this, pX, pY, pW, 1));
        this.scan = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX, bY).withShortcut(bindings.field_1869)).showing(PonderGuiTextures.ICON_PONDER_IDENTIFY)).enableFade(0, 5)).withCallback(() -> {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            } else {
                ponderPartialTicksPaused = AnimationTickHolder.getPartialTicksUI(this.field_22787.method_61966());
            }
        });
        this.method_37063(this.scan);
        this.scan.atZLevel(600.0f);
        this.slowMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.field_22789 - 20 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_SLOW_MODE)).enableFade(0, 5)).withCallback(() -> this.setComfyReadingEnabled(!this.isComfyReadingEnabled()));
        this.method_37063(this.slowMode);
        if (PonderIndex.editingModeActive()) {
            this.userMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.field_22789 - 50 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_USER_MODE)).enableFade(0, 5)).withCallback(() -> {
                this.userViewMode = !this.userViewMode;
            });
            this.method_37063(this.userMode);
        }
        this.left = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.field_1913)).showing(PonderGuiTextures.ICON_PONDER_LEFT)).enableFade(0, 5)).withCallback(() -> this.scroll(false));
        this.method_37063(this.left);
        this.close = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.field_1822)).showing(PonderGuiTextures.ICON_PONDER_CLOSE)).enableFade(0, 5)).withCallback(this::method_25419);
        this.method_37063(this.close);
        this.right = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.field_1849)).showing(PonderGuiTextures.ICON_PONDER_RIGHT)).enableFade(0, 5)).withCallback(() -> this.scroll(true));
        this.method_37063(this.right);
        this.replay = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.field_1881)).showing(PonderGuiTextures.ICON_PONDER_REPLAY)).enableFade(0, 5)).withCallback(this::replay);
        this.method_37063(this.replay);
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showingElement((RenderElement)((GuiGameElement.GuiItemRenderBuilder)GuiGameElement.of(this.stack).scale(1.5f)).at(-4.0f, -4.0f));
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.skipCooling > 0) {
            --this.skipCooling;
        }
        if (this.referredToByTag != null) {
            for (int i = 0; i < this.scenes.size(); ++i) {
                PonderScene ponderScene = this.scenes.get(i);
                if (!ponderScene.getTags().contains(this.referredToByTag)) continue;
                if (i == this.index) break;
                this.scenes.get(this.index).fadeOut();
                this.index = i;
                this.scenes.get(this.index).begin();
                this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
                this.identifyMode = false;
                break;
            }
            this.referredToByTag = null;
        }
        this.lazyIndex.tickChaser();
        this.fadeIn.tickChaser();
        this.finishingFlash.tickChaser();
        this.nextUp.tickChaser();
        PonderScene activeScene = this.scenes.get(this.index);
        this.extendedTickLength = 0;
        if (this.isComfyReadingEnabled()) {
            activeScene.forEachVisible(TextWindowElement.class, twe -> {
                this.extendedTickLength = 2;
            });
        }
        if (this.extendedTickTimer == 0) {
            float lazyIndexValue;
            if (!this.identifyMode) {
                ++ponderTicks;
                if (this.skipCooling == 0) {
                    activeScene.tick(this.field_22787, true);
                }
            }
            if (!this.identifyMode && Math.abs((lazyIndexValue = this.lazyIndex.getValue()) - (float)this.index) > 0.001953125f) {
                this.scenes.get(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1).tick(this.field_22787, false);
            }
            this.extendedTickTimer = this.extendedTickLength;
        } else {
            --this.extendedTickTimer;
        }
        if (activeScene.getCurrentTime() == activeScene.getTotalTime() - 1) {
            this.finishingFlashWarmup = 30;
            this.nextUpWarmup = 50;
        }
        if (this.finishingFlashWarmup > 0) {
            --this.finishingFlashWarmup;
            if (this.finishingFlashWarmup == 0) {
                this.finishingFlash.setValue(1.0);
                this.finishingFlash.setValue(1.0);
            }
        }
        if (this.nextUpWarmup > 0) {
            --this.nextUpWarmup;
            if (this.nextUpWarmup == 0) {
                this.nextUp.updateChaseTarget(1.0f);
            }
        }
        this.updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return this.scenes.get(this.index);
    }

    public void seekToTime(int time) {
        if (this.getActiveScene().getCurrentTime() > time) {
            this.replay();
        }
        this.getActiveScene().seekToTime(this.field_22787, time);
        if (time != 0) {
            this.coolDownAfterSkip();
        }
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        this.hoveredTooltipItem = class_1799.field_8037;
        this.hoveredBlockPos = null;
        if (!this.identifyMode) {
            return;
        }
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        PonderScene.SceneTransform t = activeScene.getTransform();
        class_243 vec1 = t.screenToScene(mouseX, mouseY, 1000, 0.0f);
        class_243 vec2 = t.screenToScene(mouseX, mouseY, -100, 0.0f);
        Pair<class_1799, class_2338> pair = activeScene.rayTraceScene(vec1, vec2);
        this.hoveredTooltipItem = pair.getFirst();
        this.hoveredBlockPos = pair.getSecond();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.scroll(scrollY > 0.0)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    protected void replay() {
        this.identifyMode = false;
        PonderScene scene = this.scenes.get(this.index);
        if (AllKeys.hasShiftDown()) {
            PonderIndex.reload();
            this.scenes.clear();
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(scene.getLocation()));
        }
        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = this.index;
        this.index = forward ? this.index + 1 : this.index - 1;
        this.index = class_3532.method_15340((int)this.index, (int)0, (int)(this.scenes.size() - 1));
        if (prevIndex != this.index) {
            this.scenes.get(prevIndex).fadeOut();
            this.scenes.get(this.index).begin();
            this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
            this.identifyMode = false;
            return true;
        }
        this.index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        partialTicks = PonderUI.getPartialTicks();
        this.renderVisibleScenes(graphics, mouseX, mouseY, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        this.renderWidgets(graphics, mouseX, mouseY, this.identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    protected void renderVisibleScenes(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_1041 window = graphics.field_44656.method_22683();
        float uiTicks = this.lazyIndex.getValue(AnimationTickHolder.getPartialTicksUI(this.field_22787.method_61966()));
        this.renderScene(graphics, 0, window, this.index, partialTicks, uiTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - (float)this.index) > 0.001953125f) {
            this.finishingFlashWarmup = 0;
            this.renderScene(graphics, 1, window, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, partialTicks, uiTicks);
        }
    }

    protected void renderScene(class_332 graphics, int id, class_1041 window, int i, float partialTicks, float uiTicks) {
        double diff = (float)i - uiTicks;
        double slide = class_3532.method_16436((double)(diff * diff), (double)200.0, (double)600.0) * diff;
        PonderScene scene = this.scenes.get(i);
        graphics.field_59826.method_70922((class_11256)new SceneRenderState(id, scene, this.field_22789, this.field_22790, slide, this.userViewMode, this.finishingFlash, partialTicks, window, new Matrix3x2f((Matrix3x2fc)graphics.method_51448())));
    }

    protected void renderWidgets(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        float fade = this.fadeIn.getValue(partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        float indexDiff = lazyIndexValue - (float)this.index;
        PonderScene activeScene = this.scenes.get(this.index);
        PonderScene nextScene = this.scenes.size() > this.index + 1 ? this.scenes.get(this.index + 1) : null;
        boolean noWidgetsHovered = true;
        for (class_364 child : this.method_25396()) {
            noWidgetsHovered &= !child.method_25405((double)mouseX, (double)mouseY);
        }
        int tooltipColor = ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB();
        this.renderSceneInformation(graphics, fade, indexDiff, activeScene, tooltipColor);
        Matrix3x2fStack ms = graphics.method_51448();
        if (this.identifyMode) {
            if (noWidgetsHovered && mouseY < this.field_22790 - 80) {
                if (this.hoveredTooltipItem.method_7960()) {
                    class_5250 text = Ponder.lang().translate("ui.identify_mode", ((class_5250)this.field_22787.field_1690.field_1869.method_16007()).method_27692(class_124.field_1068)).style(class_124.field_1080).component();
                    List<class_2561> tooltipLines = this.field_22793.method_27527().method_27495((class_5348)text, this.field_22789 / 3, class_2583.field_24360).stream().map(t -> class_2561.method_43470((String)t.getString())).toList();
                    graphics.method_51434(this.field_22793, tooltipLines, mouseX, mouseY);
                } else {
                    graphics.method_51446(this.field_22793, this.hoveredTooltipItem, mouseX, mouseY);
                }
                if (this.hoveredBlockPos != null && PonderIndex.editingModeActive() && !this.userViewMode) {
                    boolean copied = this.hoveredBlockPos.equals((Object)this.copiedBlockPos);
                    class_5250 coords = class_2561.method_43470((String)(this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260())).method_27692(copied ? class_124.field_1060 : class_124.field_1065);
                    graphics.method_51438(this.field_22793, (class_2561)coords, 0, -15);
                }
            }
            this.scan.flash();
        } else {
            this.scan.dim();
        }
        if (PonderIndex.editingModeActive()) {
            if (this.userViewMode) {
                this.userMode.flash();
            } else {
                this.userMode.dim();
            }
        }
        if (this.isComfyReadingEnabled()) {
            this.slowMode.flash();
        } else {
            this.slowMode.dim();
        }
        this.renderSceneOverlay(graphics, partialTicks, lazyIndexValue, Math.abs(indexDiff));
        this.renderNextUp(graphics, partialTicks, nextScene);
        this.getRenderables().forEach(w -> {
            if (w instanceof PonderButton) {
                PonderButton button = (PonderButton)w;
                button.fade().startWithValue(fade);
            }
        });
        if (this.index == 0 || this.index == 1 && lazyIndexValue < (float)this.index) {
            this.left.fade().startWithValue(lazyIndexValue);
        }
        if (this.index == this.scenes.size() - 1 || this.index == this.scenes.size() - 2 && lazyIndexValue > (float)this.index) {
            this.right.fade().startWithValue((float)this.scenes.size() - lazyIndexValue - 1.0f);
        }
        if (activeScene.isFinished()) {
            this.right.flash();
        } else {
            this.right.dim();
            this.nextUp.updateChaseTarget(0.0f);
        }
        Color c1 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(64);
        Color c2 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(32);
        Color c3 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(16);
        UIRenderHelper.breadcrumbArrow(graphics, this.field_22789 / 2 - 20, this.field_22790 - 51, 20, 20, 5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, this.field_22789 / 2 + 20, this.field_22790 - 51, -20, 20, -5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, this.field_22789 / 2 - 90, this.field_22790 - 51, 70, 20, 5, c1, c3);
        UIRenderHelper.breadcrumbArrow(graphics, this.field_22789 / 2 + 90, this.field_22790 - 51, -70, 20, -5, c1, c3);
        List<PonderTag> sceneTags = activeScene.getTags();
        boolean highlightAll = sceneTags.stream().anyMatch(tag -> tag.getId() == PonderTag.Highlight.ALL);
        IntStream.range(0, this.tagButtons.size()).forEach(i -> {
            ms.pushMatrix();
            PonderTag tag = this.tags.get(i);
            LerpedFloat chase = this.tagFades.get(i);
            PonderButton button = this.tagButtons.get(i);
            if (button.method_25405(mouseX, mouseY)) {
                chase.updateChaseTarget(1.0f);
            } else {
                chase.updateChaseTarget(0.0f);
            }
            chase.tickChaser();
            if (highlightAll || sceneTags.contains(tag)) {
                button.flash();
            } else {
                button.dim();
            }
            int x = button.method_46426() + button.method_25368() + 4;
            int y = button.method_46427() - 2;
            ms.translate((float)x, (float)y + 5.0f * (1.0f - fade));
            float fadedWidth = 200.0f * chase.getValue(partialTicks);
            UIRenderHelper.streak(graphics, 0.0f, 0, 12, 26, (int)fadedWidth);
            graphics.method_44379(0, 8, (int)fadedWidth, 8 + this.field_22790);
            String tagName = tag.getTitle();
            graphics.method_51433(this.field_22793, tagName, 3, 8, ((Color)UIRenderHelper.COLOR_TEXT_ACCENT.getFirst()).getRGB(), false);
            graphics.method_44380();
            ms.popMatrix();
        });
        this.renderHoverTooltips(graphics, tooltipColor);
    }

    private void renderHoverTooltips(class_332 graphics, int tooltipColor) {
        int tooltipY = this.field_22790 - 16;
        if (this.scan.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.identify", new Object[0]).component(), this.scan.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.index != 0 && this.left.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.previous", new Object[0]).component(), this.left.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.close.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.close", new Object[0]).component(), this.close.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.index != this.scenes.size() - 1 && this.right.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.next", new Object[0]).component(), this.right.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.replay.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.replay", new Object[0]).component(), this.replay.method_46426() + 10, tooltipY, tooltipColor);
        }
        if (this.slowMode.method_25367()) {
            graphics.method_27534(this.field_22793, (class_2561)Ponder.lang().translate("ui.slow_text", new Object[0]).component(), this.slowMode.method_46426() + 5, tooltipY, tooltipColor);
        }
        if (PonderIndex.editingModeActive() && this.userMode.method_25367()) {
            graphics.method_25300(this.field_22793, "Editor View", this.userMode.method_46426() + 10, tooltipY, tooltipColor);
        }
    }

    private void renderNextUp(class_332 graphics, float partialTicks, @Nullable PonderScene nextScene) {
        if (!this.getActiveScene().isFinished()) {
            return;
        }
        if (nextScene == null || !nextScene.isNextUpEnabled()) {
            return;
        }
        if (!(this.nextUp.getValue() > 0.0625f)) {
            return;
        }
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)(this.right.method_46426() + 10), (float)(this.right.method_46427() - 6) + this.nextUp.getValue(partialTicks) * 5.0f);
        class_5250 nextUpComponent = Ponder.lang().translate("ui.next_up", new Object[0]).component();
        int boxWidth = Math.max(this.field_22793.method_1727(nextScene.getTitle()), this.field_22793.method_27525((class_5348)nextUpComponent)) + 5;
        PonderUI.renderSpeechBox(graphics, 0, 0, boxWidth, 20, this.right.method_25367(), Pointing.DOWN, false);
        poseStack.translate(0.0f, -29.0f);
        graphics.method_27534(this.field_22793, (class_2561)nextUpComponent, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB());
        graphics.method_25300(this.field_22793, nextScene.getTitle(), 0, 10, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.popMatrix();
    }

    private void renderSceneOverlay(class_332 graphics, float partialTicks, float lazyIndexValue, float indexDiff) {
        float scenePT = this.skipCooling > 0 ? 0.0f : partialTicks;
        this.renderOverlay(graphics, this.index, scenePT);
        if (indexDiff > 0.001953125f) {
            this.renderOverlay(graphics, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, scenePT);
        }
    }

    private void renderSceneInformation(class_332 graphics, float fade, float indexDiff, PonderScene activeScene, int tooltipColor) {
        int otherTitleWidth;
        float indexOffset;
        float absoluteIndexDiff = Math.abs(indexDiff);
        int otherIndex = this.index;
        if (this.scenes.size() != 1 && (double)absoluteIndexDiff >= 0.01 && ((otherIndex = this.index + (int)(indexOffset = Math.signum(indexDiff))) < 0 || otherIndex >= this.scenes.size())) {
            return;
        }
        String title = activeScene.getTitle();
        String otherTitle = this.scenes.get(otherIndex).getTitle();
        int maxTitleWidth = 180;
        int titleWidth = this.field_22793.method_1727(title);
        if (titleWidth > maxTitleWidth) {
            titleWidth = maxTitleWidth;
        }
        if ((otherTitleWidth = this.field_22793.method_1727(otherTitle)) > maxTitleWidth) {
            otherTitleWidth = maxTitleWidth;
        }
        int wrappedTitleHeight = this.field_22793.method_44378((class_5348)class_2561.method_43470((String)title), maxTitleWidth);
        int otherWrappedTitleHeight = this.field_22793.method_44378((class_5348)class_2561.method_43470((String)otherTitle), maxTitleWidth);
        int streakHeight = 26 + class_3532.method_48781((float)absoluteIndexDiff, (int)wrappedTitleHeight, (int)otherWrappedTitleHeight);
        int streakWidth = 70 + class_3532.method_48781((float)absoluteIndexDiff, (int)titleWidth, (int)otherTitleWidth);
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(55.0f, 19.0f);
        UIRenderHelper.streak(graphics, 0.0f, 0, streakHeight / 2, streakHeight, (int)((float)streakWidth * fade));
        UIRenderHelper.streak(graphics, 180.0f, 0, streakHeight / 2, streakHeight, (int)(30.0f * fade));
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BACKGROUND_FLAT)).gradientBorder(COLOR_IDLE)).at(-34.0f, 2.0f, 100.0f).withBounds(30, 30).render(graphics);
        this.itemRender.render(graphics);
        poseStack.translate(4.0f, 6.0f);
        graphics.method_51439(this.field_22793, (class_2561)Ponder.lang().translate("ui.pondering", new Object[0]).component(), 0, 0, tooltipColor, false);
        poseStack.translate(0.0f, 14.0f);
        if (this.scenes.size() == 1 || (double)absoluteIndexDiff < 0.01) {
            ClientFontHelper.drawSplitString(graphics, this.field_22793, title, 0, 0, maxTitleWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(fade).getRGB());
            poseStack.popMatrix();
            return;
        }
        graphics.field_59826.method_70922((class_11256)new TitleTextRenderState(new Matrix3x2f((Matrix3x2fc)poseStack), 0, 0, indexDiff, title, otherTitle));
        poseStack.popMatrix();
    }

    private void renderOverlay(class_332 graphics, int i, float partialTicks) {
        if (this.identifyMode) {
            return;
        }
        Matrix3x2fStack matrices = graphics.method_51448();
        matrices.pushMatrix();
        PonderScene story = this.scenes.get(i);
        story.renderOverlay(this, graphics, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        matrices.popMatrix();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.identifyMode && this.hoveredBlockPos != null && PonderIndex.editingModeActive()) {
            class_1041 window = this.field_22787.method_22683();
            if (this.copiedBlockPos != null && click.method_74245() == 1) {
                this.clipboardHelper.method_15979(window, "util.select().fromTo(" + this.copiedBlockPos.method_10263() + ", " + this.copiedBlockPos.method_10264() + ", " + this.copiedBlockPos.method_10260() + ", " + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
                this.copiedBlockPos = this.hoveredBlockPos;
                return true;
            }
            if (AllKeys.hasShiftDown()) {
                this.clipboardHelper.method_15979(window, "util.select().position(" + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
            } else {
                this.clipboardHelper.method_15979(window, "util.grid().at(" + this.hoveredBlockPos.method_10263() + ", " + this.hoveredBlockPos.method_10264() + ", " + this.hoveredBlockPos.method_10260() + ")");
            }
            this.copiedBlockPos = this.hoveredBlockPos;
            return true;
        }
        return super.method_25402(click, doubled);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (this.chapter != null) {
            return this.chapter.getTitle();
        }
        return this.stack.method_7909().method_63680().getString();
    }

    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < (double)x) && !(mouseX > (double)(x + w));
        return hovered &= !(mouseY < (double)y) && !(mouseY > (double)(y + h));
    }

    public static void renderSpeechBox(class_332 graphics, int x, int y, int w, int h, boolean highlighted, Pointing pointing, boolean returnWithLocalTransform) {
        int divotRotation;
        Matrix3x2fStack poseStack = graphics.method_51448();
        if (!returnWithLocalTransform) {
            poseStack.pushMatrix();
        }
        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        Couple<Color> borderColors = highlighted ? PonderButton.COLOR_HOVER : COLOR_IDLE;
        Color c = switch (pointing) {
            default -> {
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                yield (Color)borderColors.getSecond();
            }
            case Pointing.LEFT -> {
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.RIGHT -> {
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.UP -> {
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
                yield (Color)borderColors.getFirst();
            }
        };
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BACKGROUND_FLAT)).gradientBorder(borderColors)).at(boxX, boxY, 100.0f).withBounds(w, h).render(graphics);
        poseStack.pushMatrix();
        poseStack.translate((float)(divotX + divotRadius), (float)(divotY + divotRadius));
        poseStack.rotate((float)divotRotation * ((float)Math.PI / 180));
        poseStack.translate((float)(-divotRadius), (float)(-divotRadius));
        PonderGuiTextures.SPEECH_TOOLTIP_BACKGROUND.render(graphics, 0, 0);
        PonderGuiTextures.SPEECH_TOOLTIP_COLOR.render(graphics, 0, 0, c);
        poseStack.popMatrix();
        if (returnWithLocalTransform) {
            poseStack.translate((float)boxX, (float)boxY);
            return;
        }
        poseStack.popMatrix();
    }

    public class_1799 getHoveredTooltipItem() {
        return this.hoveredTooltipItem;
    }

    public class_1799 getSubject() {
        return this.stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI otherUI = (PonderUI)other;
            return !otherUI.stack.method_7960() && this.stack.method_31574(otherUI.stack.method_7909());
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI ponderUI = (PonderUI)other;
            ponderUI.referredToByTag = this.referredToByTag;
        }
    }

    public static float getPartialTicks() {
        class_310 mc = class_310.method_1551();
        float renderPartialTicks = AnimationTickHolder.getPartialTicksUI(mc.method_61966());
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof PonderUI) {
            PonderUI ui = (PonderUI)class_4372;
            if (ui.identifyMode) {
                return ponderPartialTicksPaused;
            }
            return (renderPartialTicks + (float)(ui.extendedTickLength - ui.extendedTickTimer)) / (float)(ui.extendedTickLength + 1);
        }
        return renderPartialTicks;
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public void coolDownAfterSkip() {
        this.skipCooling = 15;
    }

    @Override
    public void method_25432() {
        super.method_25432();
        SoundScapes.setInstance(null);
        this.field_22787.method_1483().method_18670(false);
        this.hoveredTooltipItem = class_1799.field_8037;
        this.itemRender.clear();
        for (PonderTag tag : this.tags) {
            tag.clear();
        }
        for (PonderScene scene : this.scenes) {
            scene.clear();
        }
    }

    public boolean isComfyReadingEnabled() {
        return (Boolean)PonderConfig.client().comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        PonderConfig.client().comfyReading.set(slowTextMode);
    }

    static {
        BACKGROUND_TRANSPARENT = new Color(-587202560, true);
        BACKGROUND_FLAT = new Color(-16777216, true);
        BACKGROUND_IMPORTANT = new Color(-586281440, true);
        COLOR_IDLE = Couple.create(new Color(1090514653, true), new Color(553643741, true)).map(Color::setImmutable);
        COLOR_HOVER = Couple.create(new Color(0x70FFFFFF, true), new Color(0x30FFFFFF, true)).map(Color::setImmutable);
        COLOR_HIGHLIGHT = Couple.create(new Color(-251662627, true), new Color(1627385565, true)).map(Color::setImmutable);
        MISSING_VANILLA_ENTRY = Couple.create(new Color(0x505000FF, true), new Color(1344798847, true)).map(Color::setImmutable);
        MISSING_MODDED_ENTRY = Couple.create(new Color(1889027328, true), new Color(1885938688, true)).map(Color::setImmutable);
    }
}

